clc;
clear;
close;

// Parameters
N = 100;                 // Number of users
R = 300;                // Radius of user distribution area (meters)
B = 20e6;               // Bandwidth in Hz
P_tx = [1e-3 5e-3 10e-3];               // Transmission power in Watts
f = 3e9;                // Frequency in Hz
c = 3e8;                // Speed of light in m/s
N0 = 1e-9;              // Noise power spectral density in W/Hz
P_prop = 20;            // Propulsion power in Watts
//PL_0 = 20;              // Reference path loss in dB
eta = 2;                // Path loss exponent

a1 = [0.1];             b1 = [21];     // Environmental Parameters
alpha1 = [5.2];         beta1 = [0.35];

eta_los = 10 * log10(a1);               // LOS excessive path loss 
eta_Nlos = 10 * log10(b1);              // NLOS excessive path loss 

// Altitudes for UAV
uav_altitudes = 50:10:300;              // Altitudes from 50m to 300m
EE = zeros(1, length(uav_altitudes));   // Preallocate energy efficiency array

// Generate user positions
r = R * sqrt(rand(1, N));            // Random distances within radius
theta = 2 * %pi * rand(1, N);        // Random angles
x = r .* cos(theta);                 // x-coordinates of users
y = r .* sin(theta);                 // y-coordinates of users
for i=1:3

for j = 1:length(uav_altitudes)
    altitude = uav_altitudes(j);

    // Calculate distances from UAV to users
    distances = sqrt(r.^2 + altitude^2);          // Distance from UAV to each user

    // Path loss calculations
    A = eta_los - eta_Nlos;
    B = 20 * log10(distances) + 20 * log10((4 * %pi * f) / c) + eta_Nlos;
    theta_1 = (180 / %pi) * atan(altitude ./ sqrt(r.^2));
    P_L1 = A ./ (1 + (alpha1 * exp(-beta1 * (theta_1 - alpha1))));  
    P_L = P_L1 + B;                              // Path loss for each user       
    PL_dB = mean(P_L);                           // Average path loss across users

    // Convert Path Loss to Linear Scale
    PL_linear = 10.^(-PL_dB / 10);               // Convert dB to linear scale

    // Data rate for each user
    SINR = (P_tx(i) * PL_linear) ./ (N0 * B);        // SINR (scalar division)
    R_users = B.*log2(1 + SINR);                // Data rate for each user
    R_total = sum(R_users);                      // Total data rate across all users

    // Energy efficiency calculation
    P_total = P_tx(i) + P_prop;                    // Total power consumption
    EE(j) = R_total ./ P_total;                  // Energy efficiency (bits/Joule)
end
// Find the optimal altitude
[max_EE, max_index] = max(EE);          // Maximum energy efficiency and index
optimal_altitude =uav_altitudes(max_index); // Optimal altitude
// Plot energy efficiency vs. altitude
colors = ["b", "r", "g"]; // Blue, Red, Green, Magent
plot(uav_altitudes, EE, colors(i), "LineWidth", 2);
//plot(optimal_altitude, max_EE, "ro", "MarkerSize", 8); // Mark optimal point
end
xlabel("Altitude (m)");
ylabel("Energy Efficiency (bits/Joule)");
title("Energy Efficiency vs. UAV Altitude");
legends = ["Pt=1mW","Pt=5mW", "Pt=10mW"];
legend(legends, "Location", "northwest");
xgrid


